<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY versio "1.3b">
]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- 
    piv_essai.xsl

    Aplikebla kiel stilfolio al piv1.xml
  -->

  <!--
    Diversaj listoj
  -->
  
  <xsl:key name="radikoj" 
           match="//radiko" 
           use="kap"/>

  <xsl:key name="O-radikoj" 
           match="//radiko[@kat = 'o']" 
           use="kap"/>

  <xsl:key name="I-radikoj" 
           match="//radiko[@kat = 'i']" 
           use="kap"/>

   <xsl:key name="O-kunmetaĵoj" 
           match="//radiko/drv[(substring-after(@strukt,'~') = 'o') and (@strukt != '~o')]" 
           use="@form"/>

  <xsl:variable name="minuskloj" select="'abcĉdefgĝhĥijĵklmnoprsŝtuŭvz'"/>
  <xsl:variable name="majuskloj" select="'ABCĈDEFGĜHĤIJĴKLMNOPRSŜTUŬVZ'"/>
  
  <xsl:output method="html"/>


  <xsl:template match="/">
    <HTML>
      <HEAD>
        <link type="text/css" rel="stylesheet" href="piv.css" />
        <TITLE>Kapvortoj en PIV1</TITLE>
        <style type="text/css">
          <![CDATA[
            BODY {
              font-family: Arial;
              margin-right: 0.5cm;
            }
            H2 {
              font-size: 160%; 
              font-style: normal; font-weight: bolder;
              text-align: center;
            }
            H4 {
              margin-left: 1cm;
              font-size: 140%; 
              font-style: normal; font-weight: bolder;
            }
            H5 {
              margin-left: 1.5cm;
              font-size: 120%; 
              font-style: italic; font-weight: bolder;
            }
            P {
              margin-left: 2cm;
              text-align: justify;
            }
            UL {
              margin-left: 3cm;
            }
            UL.interna {
              margin-left: 1cm;
            }
            .rezultoj {
              font-size: 90%; 
              text-align: justify;
            }
          ]]>
        </style>

      </HEAD>
      <BODY>
      <CENTER>Versio &versio;<p/></CENTER>
      <HR size="5"/>

      <H2>Datumbazo de kapvortoj en PIV1</H2>

      <H4>1. Deveno de la datumbazo</H4>

      <P>Por ellabori ĉi tiun datumbazon mi uzis la BSO-liston, kuŝantan jam de jaroj en la
      reto, ekz-e ĉe la adreso 
      <A HREF="ftp://ftp.stack.nl/pub/esperanto/word-lists.dir/piv.tar.Z">
                ftp://ftp.stack.nl/pub/esperanto/word-lists.dir/piv.tar.Z</A>.
      Kiel estas konate, la listo estas erarplena kaj estas disponebla almenaŭ unu erarlisto
      (tiu de Fred de Geus), sed dum mia laboro mi havis la okazon korekti dekojn pli. La
      liston mi konvertis al XML-formato, uzante Perl-an skripton.</P>

      <UL class="interna">
      <P>La rezultanta XML-dosiero estas trovebla <A HREF="piv1.xml">ĉi tie</A> (4 Mbajt),
      ĝia dokumenttipdifino <A HREF="piv1.dtd">ĉi tie</A>
      kaj ĝia sĥemo <A HREF="piv1.xsd">ĉi tie</A>.</P>

      <P>La modifita BSO-listo estas trovebla <A HREF="piv1.txt">ĉi tie</A>.</P>

      <P>Ĉi tiu TTT-paĝo estis kreita per aplikado de ekzempla XSLT-stilfolio al la
      datumbazo. La stilfolio estas trovebla <A HREF="piv_essai.xsl">ĉi tie</A>.</P>

      <P>Ĉiuj kvin en densigita ZIP-formato: <A HREF="piv1.zip">ĉi tie</A> (800 Kbajt).</P>
      
      <P>(elŝutu ilin per dekstra musklako sur la ligo)</P>
      </UL>

      <H4>2. Mankoj de la BSO-listo kaj de PIV1</H4>

      <H5>Eraroj en la radika kapvorto</H5>

      <P>Nemalofte aperas ortografiaj eraroj en la radikaj kapvortoj. Pro tio, ke la listo
      estis alfabete reordigita (kun la eraroj kaj prenante la finaĵojn en kalkulo), estas foje
      malfacile retrovi, pri kio temas. Ekz-e mi longe cerbumis, kio povas esti tiu vorto
      STERKO en la fako kuirarto (fakte STEKO), aŭ ROMANTIKA en la fako matematiko (fakte
      ROMANIKA en la fako filologio)... Kompreneble eraroj troviĝas ankaŭ en aliaj lokoj.</P>

      <H5>Ĉapelitaj literoj</H5>

      <P>La BSO-listo uzas la konvencion de x-surogatoj por la ĉapelitaj literoj, krom por la
      litero ŭ, bedaŭrinde, kiu fariĝas simpla u. Estas tikla afero korekti tion, sed mi faris,
      kaj esperas, ke ne enkondukis tro da eraroj.</P>

      <H5>Streketoj</H5>

      <P>Ĉar oni uzis streketon por indiki la radikon en kunmetaĵoj, ne plu eblis uzi ĝin
      alicele, do la streketojn aperantajn en kunmetaĵoj oni jen forigis, jen transformis al
      spacetoj. Mi ŝanĝis la streketojn al tildoj kaj provis reenkonduki la mankantajn
      streketojn.</P>

      <H5>Preferataj formoj</H5>

      <P>Ofte en PIV1 estas vortoj difinitaj per nura egaleco kun alia vorto. La BSO-listo bone
      kaptas tion, se temas pri la ĉefa derivaĵo, sed ne pri la ceteraj. Tiu manko transiris al
      mia datumbazo.</P>

      <H5>Uskleco</H5>

      <P>En la BSO-listo ĉio estas skribita majuskle. Estas tamen indikoj pri majuskleco pere
      de la kodo MA. Sed tio ne solvas ĉiujn subtilaĵojn: radikaj kapvortoj de la tipo "S.O.S",
      "pH", "Bet-Leĥem" k.a. ne estas adekvate priskribitaj per la nura fakto, ke ili alprenas
      majusklon. Same pri kunmetaĵoj de la tipo "Alaska Markolo", "Van de Graaf-generatoro",
      "pilo de Clark", "Malta febro", "la Ora Hordo", "La Bovisto" (eĉ nekonsiderante, ke
      kelkaj kunmetaĵoj estas erare presitaj majuskle en PIV1 mem: "Malĉefa", "Senbalastigi"...
      kaj tiele konservitaj en la BSO-listo). </P>

      <P>Aldone al tio, PIV1 neglektis indiki la usklecon de kunmetaĵoj el la radikoj, kies
      ĉefa derivaĵo estas mem majuskligita (ekz-e Franc/o, ~ujo, ~igi, aŭ Kanad/o, ~ano),
      lasante la demandon malferma. Kompreneble la BSO-listo ne klopodas solvi ĝin.</P>

      <P>La informoj pri uskleco, kiun mi donas en la datumbazo, estas do nur indikaj. Se
      mankas la atributo "maj", la vorto estas tute minuskla. Se la atributo "maj" egalas al
      "jes" kaj la koncerna formo estas unuvorta, tiam ĝi alprenas komencan majusklon. Se ĝi
      estas plurvorta, aŭ se temas pri mallongigo, tiam oni povas certi, ke aperas iu majusklo,
      sed ĝia loko ne estas prognozebla aŭtomate. Se la atributo "maj" egalas al "eble", tio
      signifas, ke la radika kapvorto estas majuskla, do ke en la koncerna kunmetaĵo majusklo
      povas aperi aŭ ne depende de la semantiko aŭ de la uzata konvencio.</P>

      <H5>Mankantaj fak-indikoj</H5>

      <P>Indikado de fakoj ne estas konsekvenca en PIV1. Fakindiko povas aperi ĉe radiko (aŭ,
      pli ĝuste, ĉe la radika kapvorto, kiun mi nomas "ĉefa derivaĵo"), ĉe senco, ĉe derivaĵo
      aŭ kunmetaĵo, kaj ĉe ekzemplo... Kiam la fontindiko mankas, oni povas indukti, ke eble
      antaŭa fakindiko aplikiĝas (ekz-e  la fakindiko botaniko de "abio" aplikiĝas ankaŭ al la
      kunmetaĵo "balzama abio").</P>

      <P>La redaktantoj de la BSO-listo provis fidele respeguli la komplikecon de PIV1, sed
      ankoraŭ pli kompligis la aferon, ĉar ili prenis en kalkulon nur la kapvortojn, ne la
      diversajn sencojn, kiujn ĉiu kunmetaĵo povas ricevi. Do post la kapvorto aperas listo
      sumiganta ĉiujn fakindikojn (interplektitajn kun indikoj pri fonto, uskleco,
      transitiveco) aplikeblajn al la koncerna vorto. Notu, ke ĉi tiu listo ne entenas la
      fakindikojn troveblajn en ekzemploj, kaj ke kiam aperas pluraj fakindikoj, restas
      nesciate, ĉu la indikoj koncernas diversajn sencojn aŭ la saman.</P>

      <P>La redaktantoj provis ankaŭ plibonigi la staton en PIV aldonante proprajn fakindikojn,
      kiam PIV1 tute ne havis. Temas pri specifaj fakindikoj (GRA, I, KOM, PE, SC), tamen kun
      ne tre klara signifo (vidu mian interpreton en la enkonduka komento de piv1.xml). Ekz-e
      la vorto "abismo" portas la fakindikojn BIB (PIV-a) kaj KOM (ne-PIV-a), kio montras, ke
      la vorto estas uzebla kaj en biblia kaj en nefaka (komuna) kuntekstoj; "aboco" portas la
      fakindikojn GRA kaj KOM (ambaŭ ne-PIV-aj), kio montras, ke malgraŭ ke neniu vinjeto
      aperas en PIV1, ĝi estas tamen uzata en gramatika kaj komuna kuntekstoj. Bedaŭrindege tiu
      ĉi bona sistemo koncernas nur la ĉefajn derivaĵojn. Ĉe vorto "elaĉeti" vi do trovos la
      nuran fakindikon RE (religio), dum ĝi estas uzebla ankaŭ en komuna kunteksto.</P>

      <P>Tiuj mankoj, kompreneble, troviĝas senŝanĝe ankaŭ en mia datumbazo. Mi transprenis
      ĉiujn haveblajn fakindikojn (PIV-ajn kaj ne-PIV-ajn).</P>

      <H5>Kategoriigo de la radikoj</H5>

      <P>La BSO-listo pli-malpli reprenis la metodojn de PIV1 por distingi vortojn kun finaĵo
      aŭ senfinaĵajn, afiksojn ktp, pere de iuj signoj metitaj en la kapvorto. Mi provis
      plusistemigi la aferon, donante eksplicitan kategorion al ĉiu radiko, kaj provante tiel
      igi la datumbazon pli utila. Vidu la kategoriliston en la enkonduka komento de piv1.xml.
      Ne temas pri listo sendisputa, definitiva kaj teorie ellaborita, sed ĝi jam ebligas
      traserĉi la datumbazon.</P>

      <H4>3. Uz-ekzemploj</H4>

      <P>Mi faris XSLT-stilfolion por montri, kiamaniere kaj kiucele eblas traserĉi la
      datumbazon. Cetere la rezultoj de traserĉado ebligis korekti amasojn da eraroj en la
      BSO-listo kaj en la konvertoprogramo. </P>

      <P>Jen la ekzemploj:</P>

      <UL>
        <LI>Diversaj teĥnikaj radikkategorioj</LI>
        <UL class="interna">
          <LI><A HREF="#literoj">Listo de Esperantaj literoj</A></LI>
          <LI><A HREF="#mallongigoj">Listo de mallongigoj</A></LI>
          <LI><A HREF="#interjekcioj">Listo de interjekcioj kaj sonimitoj</A></LI>
          <LI><A HREF="#finaĵoj">Listo de finaĵoj</A></LI>
          <LI><A HREF="#E-afiksoj">Listo de Esperantaj afiksoj</A></LI>
          <LI><A HREF="#sc-afiksoj">Listo de sciencaj afiksoj</A></LI>
          <LI><A HREF="#kat_memstara">Listo de vortoj el radiko kun kategorio "memstara"</A></LI>
          <LI><A HREF="#kat_pruntita">Listo de vortoj el radiko kun kategorio "pruntita"</A></LI>
          <LI><A HREF="#kat_pruntita_adj">Listo de vortoj el radiko kun kategorio "pruntita,
            adj"</A></LI>
        </UL>
        <LI>Specifaj radikoj</LI>
        <UL class="interna">
          <LI><A HREF="#kat_e">Listo de "adverbaj" radikoj</A></LI>
          <LI><A HREF="#kat_o">Listo de substantivaj radikoj, komenciĝantaj per v</A></LI>
          <LI><A HREF="#homonimoj">Listo de homonimaj radikoj</A></LI>
        </UL>
        <LI>Vortoj de specifa fako</LI>
        <UL class="interna">
          <LI><A HREF="#fak_MAT">Listo de vortoj kun fako MAT</A></LI>
          <LI><A HREF="#fak_SHP">Listo de vortoj kun fako SHP</A></LI>
          <LI><A HREF="#fak_TEL">Listo de vortoj kun fako TEL</A></LI>
          <LI><A HREF="#fak_ZO">Listo de vortoj kun fako ZO</A></LI>
          <LI><A HREF="#FU_BO">Listo de Fundamentaj vortoj kun fako BO</A></LI>
          <LI><A HREF="#FU_Ia">Listo de Fundamentaj a- kaj eco-derivaĵoj de verba radiko</A></LI>
        </UL>
        <LI>Specifaj kunmetaĵoj</LI>
        <UL class="interna">
          <LI><A HREF="#kunmetaĵoj_kun_majusklo">Listo de kunmetaĵoj kun majusklo</A></LI>
          <LI><A HREF="#ujo">Listo de ujo-derivaĵoj</A></LI>
          <LI><A HREF="#o_i">Listo de o-derivaĵoj de verba radiko</A></LI>
          <LI><A HREF="#substantivaj_kunmetaĵoj">Listo de substantivaj kunmetaĵoj, komenciĝantaj
            per litero a</A></LI>
          <LI><A HREF="#a_kunmetaĵoj_kun_o_flankelemento">Listo de adjektivaj kunmetaĵoj kun
            substantiva flankelemento</A></LI>
        </UL>
        <LI>Diversaj listoj kontrolcelaj</LI>
        <UL class="interna">
          <LI><A HREF="#kunmetaĵoj_kun_spaceto">Listo de kunmetaĵoj kun spaceto</A></LI>
          <LI><A HREF="#kunmetaĵoj_kun_streketo">Listo de kunmetaĵoj kun streketo</A></LI>
          <LI><A HREF="#ux">Listo de vortoj kun digramoj au, eu, ou</A></LI>
        </UL>
      </UL>

      <HR SIZE="5"/>

      <A NAME="literoj"/>
      <H5>Listo de Esperantaj literoj</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'litero'"/>
        </xsl:call-template>
      </P>
      
      <A NAME="mallongigoj"/>
      <H5>Listo de mallongigoj (uskleco ofte malĝusta)</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'mallongigo'"/>
        </xsl:call-template>
      </P>
      
      <A NAME="interjekcioj"/>
      <H5>Listo de interjekcioj kaj sonimitoj</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'interjekcio'"/>
        </xsl:call-template>
      </P>

      <A NAME="finaĵoj"/>
      <H5>Listo de finaĵoj</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'finaĵo'"/>
        </xsl:call-template>
      </P>

      <A NAME="E-afiksoj"/>
      <H5>Listo de Esperantaj afiksoj</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'prefikso'"/>
        </xsl:call-template>
      </P>
      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'sufikso'"/>
        </xsl:call-template>
      </P>

      <A NAME="sc-afiksoj"/>
      <H5>Listo de sciencaj afiksoj</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'sc_prefikso'"/>
        </xsl:call-template>
      </P>
      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'sc_sufikso'"/>
        </xsl:call-template>
      </P>

      <A NAME="kat_memstara"/>
      <H5>Listo de vortoj el radiko kun kategorio "memstara" (uzataj senfinaĵe)</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'memstara'"/>
        </xsl:call-template>
      </P>

      <A NAME="kat_pruntita"/>
      <H5>Listo de vortoj el radiko kun kategorio "pruntita" (uzataj senfinaĵe)</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'pruntita'"/>
        </xsl:call-template>
      </P>

      <A NAME="kat_pruntita_adj"/>
      <H5>Listo de vortoj el radiko kun kategorio "pruntita_adj" (virinaj nomoj + epsila,
      omikra, upsila, Cefanja!)</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'pruntita_adj'"/>
        </xsl:call-template>
      </P>

      <A NAME="fak_MAT"/>
      <H5>Listo de vortoj kun fako MAT</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_fakon">
          <xsl:with-param name="fako" select="'MAT'"/>
        </xsl:call-template>
      </P>

      <A NAME="fak_SHP"/>
      <H5>Listo de vortoj kun fako SHP</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_fakon">
          <xsl:with-param name="fako" select="'SHP'"/>
        </xsl:call-template>
      </P>

      <A NAME="fak_TEL"/>
      <H5>Listo de vortoj kun fako TEL</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_fakon">
          <xsl:with-param name="fako" select="'TEL'"/>
        </xsl:call-template>
      </P>

      <A NAME="fak_ZO"/>
      <H5>Listo de vortoj kun fako ZO</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_fakon">
          <xsl:with-param name="fako" select="'ZO'"/>
        </xsl:call-template>
      </P>

      <A NAME="FU_BO"/>
      <H5>Listo de Fundamentaj vortoj kun fako BO</H5>

      <P class="rezultoj">
        <xsl:for-each select="//drv[fak/@val = 'BO' and fnt/@val = 'FU']">
          <xsl:sort select="@ord"/>
              
          <xsl:value-of select="@form"/>
           
          <xsl:choose>
            <xsl:when test="position() = last()">
              <br/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>, </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </P>

      <A NAME="FU_Ia"/>
      <H5>Listo de Fundamentaj a- kaj eco-derivaĵoj de verba radiko</H5>

      <P class="rezultoj">
        <xsl:for-each select="//radiko/drv[(@strukt = '~a' or @strukt = '~eco')
                                           and fnt/@val = 'FU' 
                                           and ../@kat = 'i']">
          <xsl:sort select="../@ord"/>
          <xsl:value-of select="@form"/> 
          <xsl:choose>
            <xsl:when test="position() = last()">
              <br/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>, </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </P>

      <A NAME="kunmetaĵoj_kun_majusklo"/>
      <H5>Listo de kunmetaĵoj kun majusklo (ordigitaj alfabete laŭ la radiko)</H5>

      <P class="rezultoj">
        <xsl:for-each select="//radiko/drv[position() != 1 and @maj = 'jes']">
          <xsl:sort select="../@ord"/>
          <xsl:value-of select="@form"/> 
          <xsl:text> (</xsl:text><xsl:value-of select="../kap"/><xsl:text>)</xsl:text>
          <xsl:choose>
            <xsl:when test="position() = last()">
              <br/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>, </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </P>

      <A NAME="kunmetaĵoj_kun_spaceto"/>
      <H5>Listo de kunmetaĵoj kun spaceto (ordigitaj alfabete laŭ la radiko, kontrolo de la
      streketigo)</H5>

      <P class="rezultoj">
        <xsl:for-each select="//radiko/drv[position() != 1 and contains(@form,' ')]">
          <xsl:sort select="../@ord"/>
          <xsl:value-of select="@form"/> 
          <xsl:text> (</xsl:text><xsl:value-of select="../kap"/><xsl:text>)</xsl:text>
          <xsl:choose>
            <xsl:when test="position() = last()">
              <br/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>, </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </P>

      <A NAME="kunmetaĵoj_kun_streketo"/>
      <H5>Listo de kunmetaĵoj kun streketo (ordigitaj alfabete laŭ la radiko, kontrolo de la
      streketigo)</H5>

      <P class="rezultoj">
        <xsl:for-each select="//radiko/drv[position() != 1 and contains(@form,'-')]">
          <xsl:sort select="../@ord"/>
          <xsl:value-of select="@form"/> 
          <xsl:text> (</xsl:text><xsl:value-of select="../kap"/><xsl:text>)</xsl:text>
          <xsl:choose>
            <xsl:when test="position() = last()">
              <br/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>, </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </P>

      <A NAME="ux"/>
      <H5>Listo de vortoj kun digramoj au, eu, ou (kontrolo de la ŭ-igo)</H5>

      <P class="rezultoj">
        <xsl:for-each select="//radiko/drv[contains(@form,'au') 
                                        or contains(@form,'eu') 
                                        or contains(@form,'ou')]">
          <xsl:sort select="@ord"/>
          <xsl:value-of select="@form"/> 
          <xsl:choose>
            <xsl:when test="position() = last()">
              <br/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>, </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </P>

      <A NAME="ujo"/>
      <H5>Listo de ujo-derivaĵoj (nefidinda, ĉar la vortoj de tipo ~/Y/ujo
      ne estas trovitaj ĉi-maniere)</H5>

      <P class="rezultoj">
        <xsl:for-each select="//radiko/drv[substring-after(@strukt, '~') = 'ujo']">
          <xsl:value-of select="@form"/>
          <xsl:choose>
            <xsl:when test="position() = last()">
              <br/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>, </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </P>

      <A NAME="o_i"/>
      <H5>Listo de o-derivaĵoj de verbaj radikoj</H5>

      <P class="rezultoj">
        <xsl:for-each select="//radiko[key('I-radikoj',kap)
                                  and (@kat = 'i')
                                  and (drv[@strukt = '~o'])]">
          <xsl:sort select="@ord"/>
          <xsl:value-of select="drv[@strukt = '~o']/@form"/>
          <xsl:choose>
            <xsl:when test="position() = last()">
              <br/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>, </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </P>

      <A NAME="substantivaj_kunmetaĵoj"/>
      <H5>Listo de substantivaj kunmetaĵoj, komenciĝantaj per litero a</H5>

      <P class="rezultoj">
        <xsl:for-each select="//radiko/drv[(@form = key('O-kunmetaĵoj',@form)/@form)
                                       and (substring(@form,1,1) = 'a')]">
          <xsl:value-of select="@form"/>
          <xsl:choose>
            <xsl:when test="position() = last()">
              <br/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>, </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </P>

      <A NAME="kat_e"/>
      <H5>Listo de "adverbaj" radikoj</H5>

      <P class="rezultoj">
        <xsl:call-template name="serĉu_kategorion">
          <xsl:with-param name="kategorio" select="'e'"/>
        </xsl:call-template>
      </P>

      <A NAME="kat_o"/>
      <H5>Listo de substantivaj radikoj, komenciĝantaj per v</H5>

      <P class="rezultoj">
        <xsl:for-each select="//radiko[key('O-radikoj',kap)
                                  and (substring(kap,1,1) = 'v')]">
          <xsl:sort select="@ord"/>
          <xsl:value-of select="kap"/>
          <xsl:choose>
            <xsl:when test="position() = last()">
              <br/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>, </xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </P>

      <A NAME="homonimoj"/>
      <H5>Listo de homonimaj radikoj</H5>

      <P class="rezultoj">
        <xsl:for-each select="//radiko[(key('radikoj',kap)[1 != last()])
                                   and (key('radikoj',kap)[1]/@id = @id)]">
          <xsl:sort select="@ord"/>
          <b><xsl:value-of select="kap"/></b><xsl:text>: </xsl:text>

          <xsl:for-each select="key('radikoj',kap)">
            <xsl:sort select="drv[1][not(@maj)]/@ord"/>
            <xsl:sort select="drv[1][@maj = 'jes']/@ord"/>
            <xsl:variable name="form" select="drv[1]/@form"/>
            
            <!-- Eventuale majuskligi la derivaĵon -->
            
            <xsl:choose>
              <xsl:when test="drv[1]/@maj = 'jes'">
                <xsl:value-of 
                  select="concat(translate(substring($form,1,1), $minuskloj, $majuskloj), 
                          substring($form,2,string-length($form)-1))"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$form"/>
              </xsl:otherwise>
            </xsl:choose>
            
            <!-- Indiki la kategorion kaj fakojn -->
            
            <xsl:choose>
              <xsl:when test="not(contains('aieo',@kat))">
                <xsl:text> (</xsl:text>
                  <xsl:value-of select="@kat"/>
                <xsl:text>)</xsl:text>
              </xsl:when>
              <xsl:when test="drv[1]/pref">
                <xsl:text> (=</xsl:text>
                  <xsl:value-of select="drv[1]/pref"/>
                <xsl:text>)</xsl:text>
              </xsl:when>
              <xsl:when test="drv[1]/fak or drv[1]/div">
                <xsl:text> (</xsl:text>
                  <xsl:for-each select="drv[1]/fak | drv[1]/div">
                    <xsl:value-of select="@val"/>
                    <xsl:if test="position() != last()">
                      <xsl:text>, </xsl:text>
                    </xsl:if>
                    </xsl:for-each>
                <xsl:text>)</xsl:text>
              </xsl:when>
              <xsl:otherwise/>
            </xsl:choose>
            <xsl:if test="position() != last()">
              <xsl:text>, </xsl:text>
            </xsl:if>
          </xsl:for-each>
          <br/>
        </xsl:for-each>
      </P>

      <A NAME="a_kunmetaĵoj_kun_o_flankelemento"/>
      <H5>Listo de adjektivaj kunmetaĵoj kun substantiva flankelemento
      (nefidinda, ĉar la programo ne kapablas distingi homonimajn radikojn)</H5>

      <P class="rezultoj">
        <xsl:for-each 
          select="//radiko/drv[
            (substring-after(@strukt,'~') = 'a') and
            (key('O-radikoj',substring-before(@strukt,'~'))/kap = substring-before(@strukt,'~'))]">
          <xsl:sort select="@ord"/>
          <xsl:if test="not(contains('.al.bel.ĉi.el.en.sen.sin.sur.',
                                     concat('.',substring-before(@strukt,'~'),'.')))">
                        <!-- forigas la plej ĝenajn nesubst. flankelementojn -->
            <xsl:value-of select="@form"/>
            <xsl:choose>
              <xsl:when test="position() = last()">
                <br/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>, </xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>
        </xsl:for-each>
      </P>

      </BODY>
    </HTML>
  </xsl:template>

  <!-- Subprogramoj -->
  
  <xsl:template name="serĉu_kategorion">
    <xsl:param name="kategorio"/>
    <xsl:for-each select="//radiko[@kat = $kategorio]">
      <xsl:sort select="@ord"/>
          
      <!-- Eventuale majuskligi la derivaĵon -->
      
      <xsl:variable name="form" select="drv[1]/@form"/>
      <xsl:choose>
        <xsl:when test="drv[1]/@maj = 'jes'">
          <xsl:value-of 
            select="concat(translate(substring($form,1,1), $minuskloj, $majuskloj), 
                    substring($form,2,string-length($form)-1))"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$form"/>
        </xsl:otherwise>
      </xsl:choose>
       
      <xsl:choose>
        <xsl:when test="position() = last()">
          <br/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>, </xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="serĉu_fakon">
    <xsl:param name="fako"/>
    <xsl:for-each select="//drv[fak/@val = $fako]">
      <xsl:sort select="@ord"/>
          
      <xsl:value-of select="@form"/>
       
      <xsl:choose>
        <xsl:when test="position() = last()">
          <br/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>, </xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>
<!-- vim:et:ts=2:sw=2:keymap=unicode:enc=utf-8
-->
